#include <windows.h> 
#include <ddraw.h> 
#include <stdio.h>
#include "gfx.h"

LPDIRECTDRAW2			lpDD;
LPDIRECTDRAWSURFACE     DD_Primary;
LPDIRECTDRAWSURFACE     DD_CFB;
LPDIRECTDRAWCLIPPER     lpDDClipper;

int      PixelFormat, FullScreen, ChangingWindow = FALSE;
short    Convet16to16[65536];
long     Convet16to32[65536];
DWORD    ViStatus, ViWidth;
RECT     rcWindow;
GFX_INFO GFXInfo;

void ChangeWinSize ( HWND hWnd, long width, HWND hStatusBar );
void DisplayError  ( HWND hParent, char * Message, ...);
void SetupCFB      ( void );

unsigned short Flip16 (unsigned short ToFlip) {
	__asm {
		mov ax,ToFlip
		xchg ah,al
		mov ToFlip,ax
	}
	return ToFlip;
}

void CloseDLL (void) {
	if (FullScreen) { ChangeWindow(); }
    if ( lpDD != NULL ) {
        if ( DD_Primary != NULL ) 
		{
            DD_Primary->Release();
            DD_Primary = NULL;
        }
		if (DD_CFB != NULL) {
			DD_CFB->Release();
			DD_CFB = NULL;
		}
        if (lpDDClipper) {
			lpDDClipper->Release();
			lpDDClipper = NULL;
		}
		lpDD->Release();
        lpDD = NULL;
	}
}

void ChangeWindow (void) {
	static WINDOWPLACEMENT wndpl;
	static HMENU OldMenu = NULL;
	static LONG OldStlye = 0;
    DDSURFACEDESC       ddsd;

	ChangingWindow = TRUE;
	if (FullScreen==false) {//GDI->Full
		FullScreen = true;
		
		wndpl.length = sizeof(wndpl);
		GetWindowPlacement( GFXInfo.hWnd, &wndpl);
		if (GFXInfo.hStatusBar) { ShowWindow(GFXInfo.hStatusBar,SW_HIDE); }
		OldMenu = GetMenu(GFXInfo.hWnd);
		if (OldMenu) { SetMenu(GFXInfo.hWnd,NULL); }
		OldStlye = GetWindowLong(GFXInfo.hWnd,GWL_STYLE);
		SetWindowLong(GFXInfo.hWnd, GWL_STYLE, WS_VISIBLE);
		SetWindowPos(GFXInfo.hWnd, HWND_TOPMOST, 0, 0, 640, 480, SWP_SHOWWINDOW);
		ShowCursor(FALSE);
		if (DD_Primary) { 
			DD_Primary->Release();
			DD_Primary = NULL;
		}
		if (lpDDClipper) { 
			lpDDClipper->Release();
			lpDDClipper = NULL;
		}
		lpDD->SetCooperativeLevel(GFXInfo.hWnd,DDSCL_ALLOWREBOOT|DDSCL_EXCLUSIVE|DDSCL_FULLSCREEN);
		lpDD->SetDisplayMode( 640, 480, 16, NULL, NULL);
	    
		ddsd.dwSize = sizeof( ddsd );
		ddsd.dwFlags = DDSD_CAPS;
		ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE;

	    if ( FAILED(lpDD->CreateSurface( &ddsd, &DD_Primary, NULL ))) {
		    ChangeWindow();
			return;
		}
		SetupCFB();
	} else {
		FullScreen = false;
		if (DD_Primary) { 
			DD_Primary->Release();
			DD_Primary = NULL;
		}
		lpDD->SetCooperativeLevel(GFXInfo.hWnd,DDSCL_NORMAL);
		lpDD->RestoreDisplayMode();

		ddsd.dwSize = sizeof( ddsd );
		ddsd.dwFlags = DDSD_CAPS;
		ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE;

		if ( FAILED(lpDD->CreateSurface( &ddsd, &DD_Primary, NULL ))) {
			CloseDLL();
		}
		

		if ( FAILED( lpDD->CreateClipper( 0, &lpDDClipper, NULL ) ) ) {
			CloseDLL();
		}

		if ( FAILED( lpDDClipper->SetHWnd( 0, GFXInfo.hWnd ) ) ) {
			CloseDLL();
		}

		if ( FAILED( DD_Primary->SetClipper( lpDDClipper ) ) ) {
			CloseDLL();
		}
		SetupCFB();

		if (GFXInfo.hStatusBar) { ShowWindow(GFXInfo.hStatusBar,SW_SHOW); }
		if (OldMenu) { 
			SetMenu(GFXInfo.hWnd,OldMenu); 
			OldMenu = NULL;
		}
		SetWindowLong(GFXInfo.hWnd, GWL_STYLE, OldStlye);
		SetWindowPos(GFXInfo.hWnd, HWND_NOTOPMOST, wndpl.rcNormalPosition.left, 
			wndpl.rcNormalPosition.top, 640, 480, SWP_NOSIZE|SWP_SHOWWINDOW);
		ChangeWinSize(GFXInfo.hWnd,*GFXInfo.VI_WIDTH_REG==0?640:*GFXInfo.VI_WIDTH_REG, GFXInfo.hStatusBar);
		ShowCursor(TRUE);
	}
	ChangingWindow = FALSE;
}

void ChangeWinSize ( HWND hWnd, long width, HWND hStatusBar ) {
	WINDOWPLACEMENT wndpl;
    RECT rc1, swrect;

	if (FullScreen) { return; }
	wndpl.length = sizeof(wndpl);
	GetWindowPlacement( hWnd, &wndpl);

	if ( hStatusBar != NULL ) {
		GetClientRect( hStatusBar, &swrect );
	    SetRect( &rc1, 0, 0, width, (width >> 2) * 3 + swrect.bottom );
	} else {
	    SetRect( &rc1, 0, 0, width, (width >> 2) * 3 );
	}


    AdjustWindowRectEx( &rc1,GetWindowLong( hWnd, GWL_STYLE ),
		GetMenu( hWnd ) != NULL, GetWindowLong( hWnd, GWL_EXSTYLE ) ); 

    MoveWindow( hWnd, wndpl.rcNormalPosition.left, wndpl.rcNormalPosition.top, 
		rc1.right - rc1.left, rc1.bottom - rc1.top, TRUE );
    
	MoveScreen(wndpl.rcNormalPosition.left, wndpl.rcNormalPosition.top);
   
}

void DisplayError (HWND hParent, char * Message, ...) {
	char Msg[400];
	va_list ap;

	va_start( ap, Message );
	vsprintf( Msg, Message, ap );
	va_end( ap );
	MessageBox(hParent,Msg,"Error",MB_OK|MB_ICONERROR|MB_SETFOREGROUND );
}

void DllAbout ( HWND hParent) {
	DisplayError (hParent,"Basic CFB plugin by zilmar");	
}

void DrawScreen (void) {
	if (ChangingWindow) { return; }
	if (DD_CFB == NULL) { return; }
	if (DD_Primary == NULL) { return; }
	DD_Primary->Blt( &rcWindow,DD_CFB,NULL,DDBLT_WAIT, NULL);
}

void GetDllInfo ( PLUGIN_INFO * PluginInfo ) {
	PluginInfo->Version = 0x0102;
	PluginInfo->Type = PLUGIN_TYPE_GFX;
	sprintf(PluginInfo->Name,"Basic CFB plugin by zilmar");
	PluginInfo->NormalMemory = TRUE;
	PluginInfo->MemoryBswaped = TRUE;
}

BOOL InitiateGFX (GFX_INFO Gfx_Info) {
	GFXInfo = Gfx_Info;
    LPDIRECTDRAW        BasiclpDD;
    DDSURFACEDESC       ddsd;
	DDPIXELFORMAT format;
	unsigned char Red, Green, Blue, Alpha;
	unsigned short Color16;
	unsigned long  Color32;
	int count;

	FullScreen = FALSE;
    if ( FAILED(DirectDrawCreate( NULL, &BasiclpDD, NULL ))) {
        CloseDLL();
		return FALSE;
    }

    if ( FAILED(BasiclpDD->SetCooperativeLevel( GFXInfo.hWnd, DDSCL_NORMAL ))) {
        CloseDLL();
		return FALSE;
    }

    if( FAILED(BasiclpDD->QueryInterface( IID_IDirectDraw2, (LPVOID *)&lpDD ))) {
        CloseDLL();
		return FALSE;
	}
	
	BasiclpDD->Release();

    ddsd.dwSize = sizeof( ddsd );
    ddsd.dwFlags = DDSD_CAPS;
    ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE;

    if ( FAILED(lpDD->CreateSurface( &ddsd, &DD_Primary, NULL ))) {
        CloseDLL();
		return FALSE;
    }
	

    if ( FAILED( lpDD->CreateClipper( 0, &lpDDClipper, NULL ) ) ) {
        CloseDLL();
		return FALSE;
    }

    if ( FAILED( lpDDClipper->SetHWnd( 0, GFXInfo.hWnd ) ) ) {
        CloseDLL();
		return FALSE;
    }

    if ( FAILED( DD_Primary->SetClipper( lpDDClipper ) ) ) {
        CloseDLL();
		return FALSE;
    }
    
	format.dwSize = sizeof(DDPIXELFORMAT);
	if (DD_Primary->GetPixelFormat(&format) != DD_OK) {
        CloseDLL();
		return FALSE;
    }
	
	PixelFormat = format.dwRGBBitCount;
	switch (PixelFormat) {
	case 8:
		DisplayError(Gfx_Info.hWnd,"Unhandled Pixel Depth 8 bit");
		return FALSE;
		break;
	case 16:
		if ( format.dwGBitMask == 0x07E0 ) {
			for (count = 0; count < 65536; count ++) {
				if (GFXInfo.MemoryBswaped) {
					Color16 = (unsigned short)count;
				} else {
					Color16 = Flip16((unsigned short)count);
				}
				Red   = (Color16 & 0xF800) >> 11;
				Green = (Color16 & 0x07C0) >> 6;
				Blue  = (Color16 & 0x003E) >> 1;
				Alpha = (Color16 & 0x0001);
				Color16  = Red << 11;
				Color16 |= Green << 6;
				Color16 |= Blue;
				*(unsigned short *)(&Convet16to16[count]) = Color16;
			}
		} else {
			for (count = 0; count < 65536; count ++) {
				if (GFXInfo.MemoryBswaped) {
					Color16 = (unsigned short)count;
				} else {
					Color16 = Flip16((unsigned short)count);
				}
				Red   = (Color16 & 0xF800) >> 11;
				Green = (Color16 & 0x07C0) >> 6;
				Blue  = (Color16 & 0x003E) >> 1;
				Alpha = (Color16 & 0x0001);
				Color16  = Red << 10;
				Color16 |= Green << 5;
				Color16 |= Blue;
				*(unsigned short *)(&Convet16to16[count]) = Color16;
			}
		}
		break;
	case 24:
		DisplayError(Gfx_Info.hWnd,"Unhandled Pixel Depth 24 bit");
		return FALSE;
		break;
	case 32:
		for (count = 0; count < 65536; count ++) {
			if (GFXInfo.MemoryBswaped) {
				Color16 = (unsigned short)count;
			} else {
				Color16 = Flip16((unsigned short)count);
			}
			Color16 = (unsigned short)count;
			Red   = (Color16 & 0xF800) >> 11;
			Green = (Color16 & 0x07C0) >> 6;
			Blue  = (Color16 & 0x003E) >> 1;
			Alpha = (Color16 & 0x0001);
			Color32  = Alpha << 27;
			Color32 |= Red << 19;
			Color32 |= Green << 11;
			Color32 |= Blue << 3;
			*(unsigned long *)(&Convet16to32[count]) = Color32;
		}
		break;
	}
	
	DD_CFB  = NULL;
	return TRUE;
}

void MoveScreen (int xpos, int ypos) {
    RECT swrect;
	
	GetClientRect( GFXInfo.hWnd, &rcWindow );
    ClientToScreen( GFXInfo.hWnd, ( LPPOINT )&rcWindow );
    ClientToScreen( GFXInfo.hWnd, ( LPPOINT )&rcWindow + 1 );
	if ( GFXInfo.hStatusBar != NULL && !FullScreen) {	
		GetClientRect( GFXInfo.hStatusBar, &swrect );
		rcWindow.bottom = rcWindow.bottom - swrect.bottom;
	}
}

void ProcessDList (void) {
	*GFXInfo.MI_INTR_REG |= 0x20;
	GFXInfo.CheckInterrupts();
}

void RomClosed (void) {
}

void RomOpen (void) {
}

void SetupCFB (void ) {
    DDSURFACEDESC       ddsd;

	if (*GFXInfo.VI_STATUS_REG == 0) { return; }
	if (*GFXInfo.VI_WIDTH_REG == 0) { return; }

	if (DD_CFB != NULL) {
		DD_CFB->Release();
        DD_CFB = NULL;
	}
    
	if ( lpDD == NULL ) { return; }

    ddsd.dwSize = sizeof( ddsd );
    ddsd.dwFlags = DDSD_CAPS | DDSD_HEIGHT |DDSD_WIDTH;
    ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN | DDSCAPS_VIDEOMEMORY ;
    ddsd.dwWidth = *GFXInfo.VI_WIDTH_REG ;
    ddsd.dwHeight = (*GFXInfo.VI_WIDTH_REG >> 2) * 3;
 
    if ( lpDD->CreateSurface( &ddsd, &DD_CFB, NULL ) != DD_OK ) {
        DD_CFB = NULL;
        CloseDLL();
		return;
    }
}

void UpdateScreen (void) {
    DDSURFACEDESC       ddsd;
	DWORD count, x;
	BYTE* SurfBuf, *buffer;
	if (DD_CFB == NULL) { return; }
    
	memset(&ddsd,0,sizeof(ddsd));
	ddsd.dwSize = sizeof( ddsd );
    ddsd.dwFlags = DDSD_LPSURFACE | DDSD_PITCH;
	if (DD_CFB->Lock(NULL,&ddsd,DDLOCK_WAIT,NULL) != DD_OK) {
		//DisplayError(GFXInfo.hWnd,"Failed To lock Surface");
		return;
	}
	buffer = GFXInfo.RDRAM + (*GFXInfo.VI_ORIGIN_REG & 0x00FFFFFF);
		
	SurfBuf = (BYTE*)ddsd.lpSurface;
	if (PixelFormat == 16) {
		for ( count = 0 ; count < ((*GFXInfo.VI_WIDTH_REG >> 2) * 3); count ++ ) {
			for ( x = 0; x < (*GFXInfo.VI_WIDTH_REG << 1); x += 4, buffer+=4 ) {
				if (GFXInfo.MemoryBswaped) {
					*(unsigned short *)(SurfBuf + x) = Convet16to16[*(unsigned short *)(buffer + 2)];	
					*(unsigned short *)(SurfBuf + x + 2) = Convet16to16[*(unsigned short *)buffer];	
				} else {
					*(unsigned short *)(SurfBuf + x) = Convet16to16[*(unsigned short *)buffer];	
					*(unsigned short *)(SurfBuf + x + 2) = Convet16to16[*(unsigned short *)(buffer + 2)];	
				}
			}
			SurfBuf+=ddsd.lPitch;
		}
	} else {
		for ( count = 0 ; count < ((*GFXInfo.VI_WIDTH_REG >> 2) * 3); count ++ ) {
			for ( x = 0; x < (*GFXInfo.VI_WIDTH_REG << 2); x += 8, buffer+=4 ) {
				if (GFXInfo.MemoryBswaped) {
					*(unsigned long *)(SurfBuf + x) = Convet16to32[*(unsigned short *)(buffer + 2)];	
					*(unsigned long *)(SurfBuf + x + 4) = Convet16to32[*(unsigned short *)buffer];	
				} else {
					*(unsigned long *)(SurfBuf + x) = Convet16to32[*(unsigned short *)buffer];	
					*(unsigned long *)(SurfBuf + x + 4) = Convet16to32[*(unsigned short *)(buffer + 2)];	
				}
			}
			SurfBuf+=ddsd.lPitch;
		}
	}
	
	DD_CFB->Unlock(ddsd.lpSurface);
	DrawScreen();
}

void ViStatusChanged (void) {
	if (*GFXInfo.VI_STATUS_REG != ViStatus) {
		SetupCFB();
		ViStatus = *GFXInfo.VI_STATUS_REG; 
	}
}

void ViWidthChanged (void) {
	if (*GFXInfo.VI_WIDTH_REG != ViWidth) {
		SetupCFB();
		ViWidth = *GFXInfo.VI_WIDTH_REG;
		ChangeWinSize(GFXInfo.hWnd,ViWidth, GFXInfo.hStatusBar);
	}
}
